<!DOCTYPE html>
<html lang="en" {{ getFrontSelectLanguageIsoCode() == 'ar' ? 'dir=rtl' : '' }}>
@php
    $settings = getSettingValue();
@endphp

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    {{--    @if (!empty(getSEOTools()->keyword)) --}}
    <meta name="keywords" content="@yield('meta_tags'),{{ !empty(getSEOTools()) ? getSEOTools()->keyword : '' }}">
    {{--    @endif --}}
    {{--    @if (!empty(getSEOTools()->site_description)) --}}
    <meta name="description"
        content="@if (View::hasSection('meta_description')) @yield('meta_description')
        @else{{ !empty(getSEOTools()) ? getSEOTools()->site_description : '' }} @endif">
    {{--    @endif --}}

    <meta http-equiv="content-language" content="{{ getFrontSelectLanguageName() ?? 'en' }}">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta property="og:image"
        content="@if (View::hasSection('meta_image')) @yield('meta_image')@else{{ $settings['logo'] }} @endif" />
    <title>@yield('title') |
        {{ !empty(getSEOTools()->site_title) ? getSEOTools()->site_title : $settings['application_name'] }} </title>

    <link rel="shortcut icon" type="image/x-icon"
        href="{{ !empty(getAppFavicon()) ? getAppFavicon() : asset('assets/image/favicon-infyom.png') }}">
    {{-- done --}}
    <link href="{{ asset('assets/css/front-third-party.css') }}" rel="stylesheet" type="text/css">
    {{-- done --}}
    {{-- <link href="{{ mix('assets/css/front-pages.css') }}" rel="stylesheet" type="text/css"> --}}
    @vite('resources/assets/front/scss/main.scss')
    @livewireStyles
    @livewireScripts
    {{-- <script src="https://cdn.jsdelivr.net/gh/livewire/turbolinks@v0.1.x/dist/livewire-turbolinks.js"
        data-turbolinks-eval="false" data-turbo-eval="false"></script> --}}
    {!! reCaptcha()->renderJs() !!}
    @php
        $langSession = Session::get('frontLanguageChange');
        $frontLanguage = !isset($langSession) ? getSettingValue()['front_language'] : $langSession;
    @endphp

    <script src='https://www.google.com/recaptcha/api.js'></script>
    {{-- done --}}
    <script src="{{ asset('assets/js/front-third-party.js') }}"></script>
    @routes
    {{-- note done --}}
    <script src="{{ asset('messages.js') }}"></script>
    <script data-turbo-eval="false">
        let userProfile = '{{ asset('images/avatar.png') }}'
        let siteKey = "{{ $settings['site_key'] }}"
        let frontLanguage = "{{ App\Models\Language::find($frontLanguage)->iso_code }}"
        let lang = "{{ getFrontSelectLanguageIsoCode() ?? 'en' }}"
        // Lang.setLocale(frontLanguage)
    </script>
    {{-- done --}}
    {{-- <script src="{{ mix('assets/js/front-pages.js') }}"></script> --}}
    {{-- @vite('resources/assets/js/turbo.js') --}}
    @vite('resources/assets/js/custom/helpers.js')
    @vite('resources/assets/js/web/custom.js')
    @vite('resources/assets/js/front/gallery-page.js')
    @vite('resources/assets/js/front/video-page.js')
    @vite('resources/assets/js/front/audio.js')
    @vite('resources/assets/js/front/home.js')
    @vite('resources/assets/js/post-reaction/post_reaction.js')
    {!! !empty(getSEOTools()->google_analytics) ? getSEOTools()->google_analytics : '' !!}
    @if (getFrontSelectLanguageIsoCode() == 'ar')
        <style>
            .section-heading h2:after {
                left: -100px !important;
                right: auto !important;


            }

            @media (max-width: 575px) {
                .section-heading h2:after {
                    left: -70px !important;
                    right: auto !important;
                }
            }

            .blog-section .blog .email-box .button {
                padding: 14px 30px;
                box-shadow: none;
                bottom: 0;
                height: 50px;
                left: 0 !important;
                right: auto !important;
            }


            .offcanvas {
                height: 100%;
                width: 400px;
                position: fixed;
                z-index: 99999;
                top: 0;
                right: 0;
                overflow-x: hidden;
                transition: 0.5s;
            }

            .offcanvas-start {
                top: 0;
                left: 0;
                width: 400px;
                border-right: 1px solid rgba(50, 64, 77, .2);
                transform: translateX(480%);
            }

            .theme-switch-box-wrap {
                left: 12px;
                right: auto;
            }

            .sticky-box {
                left: -10px;
                right: auto;
            }

            .theme-change-button {
                transform: rotate(90deg);
            }

            .theme-change-button:hover {
                transform: scale(1.1) rotate(90deg);
            }

            .breadcrumb-item+.breadcrumb-item::before {
                float: right;
                padding-left: .5rem;
                color: #6c757d;
                content: var(--bs-breadcrumb-divider, "/")
                    /* rtl: var(--bs-breadcrumb-divider, "/") */
                ;
            }

            .toast-close-button {
                top: 0.1em !important;
            }

            .hero-section .hero-image .hero-content h1 {
                padding-left: 180px;
                padding-right: 0px;
            }
        </style>
    @endif
</head>

<body class="">
    @include('front_new.layouts.header')
    <div>
        @yield('content')
    </div>

    <!-- start footer section -->
    @include('front_new.layouts.footer')
    <!-- end footer section -->
    @if ($settings['show_cookie'])
        @include('cookie-consent::index')
    @endif
    <!-- start dark-mode-section -->
    <div class="theme-switch-box-wrap">
        <div class="theme-switch-box">
            <span class="theme-status"><i class="fa-solid fa-sun"></i></span>
            <label class="switch-label" for="themeSwitchCheckbox">
                <input class="input" type="checkbox" name="themeSwitchCheckbox" id="themeSwitchCheckbox">
                <span class="switch" onclick="myFunction()"></span>
            </label>
            <span class="theme-status"><i class="fas fa-moon"></i></span>
        </div>
    </div>
    <!-- end dark-mode-section -->
    <div class='sticky-box'>
        <button type="button" class="tags fw-7 theme-change-button">Theme</button>
    </div>
    @include('setting.theme_change_modal')
</body>

</html>
