/*!
 *  Lang.js for Laravel localization in JavaScript.
 *
 *  @version 1.1.10
 *  @license MIT https://github.com/rmariuzzo/Lang.js/blob/master/LICENSE
 *  @site    https://github.com/rmariuzzo/Lang.js
 *  @author  Rubens Mariuzzo <rubens@mariuzzo.com>
 */
(function(root,factory){"use strict";if(typeof define==="function"&&define.amd){define([],factory)}else if(typeof exports==="object"){module.exports=factory()}else{root.Lang=factory()}})(this,function(){"use strict";function inferLocale(){if(typeof document!=="undefined"&&document.documentElement){return document.documentElement.lang}}function convertNumber(str){if(str==="-Inf"){return-Infinity}else if(str==="+Inf"||str==="Inf"||str==="*"){return Infinity}return parseInt(str,10)}var intervalRegexp=/^({\s*(\-?\d+(\.\d+)?[\s*,\s*\-?\d+(\.\d+)?]*)\s*})|([\[\]])\s*(-Inf|\*|\-?\d+(\.\d+)?)\s*,\s*(\+?Inf|\*|\-?\d+(\.\d+)?)\s*([\[\]])$/;var anyIntervalRegexp=/({\s*(\-?\d+(\.\d+)?[\s*,\s*\-?\d+(\.\d+)?]*)\s*})|([\[\]])\s*(-Inf|\*|\-?\d+(\.\d+)?)\s*,\s*(\+?Inf|\*|\-?\d+(\.\d+)?)\s*([\[\]])/;var defaults={locale:"en"};var Lang=function(options){options=options||{};this.locale=options.locale||inferLocale()||defaults.locale;this.fallback=options.fallback;this.messages=options.messages};Lang.prototype.setMessages=function(messages){this.messages=messages};Lang.prototype.getLocale=function(){return this.locale||this.fallback};Lang.prototype.setLocale=function(locale){this.locale=locale};Lang.prototype.getFallback=function(){return this.fallback};Lang.prototype.setFallback=function(fallback){this.fallback=fallback};Lang.prototype.has=function(key,locale){if(typeof key!=="string"||!this.messages){return false}return this._getMessage(key,locale)!==null};Lang.prototype.get=function(key,replacements,locale){if(!this.has(key,locale)){return key}var message=this._getMessage(key,locale);if(message===null){return key}if(replacements){message=this._applyReplacements(message,replacements)}return message};Lang.prototype.trans=function(key,replacements){return this.get(key,replacements)};Lang.prototype.choice=function(key,number,replacements,locale){replacements=typeof replacements!=="undefined"?replacements:{};replacements.count=number;var message=this.get(key,replacements,locale);if(message===null||message===undefined){return message}var messageParts=message.split("|");var explicitRules=[];for(var i=0;i<messageParts.length;i++){messageParts[i]=messageParts[i].trim();if(anyIntervalRegexp.test(messageParts[i])){var messageSpaceSplit=messageParts[i].split(/\s/);explicitRules.push(messageSpaceSplit.shift());messageParts[i]=messageSpaceSplit.join(" ")}}if(messageParts.length===1){return message}for(var j=0;j<explicitRules.length;j++){if(this._testInterval(number,explicitRules[j])){return messageParts[j]}}var pluralForm=this._getPluralForm(number);return messageParts[pluralForm]};Lang.prototype.transChoice=function(key,count,replacements){return this.choice(key,count,replacements)};Lang.prototype._parseKey=function(key,locale){if(typeof key!=="string"||typeof locale!=="string"){return null}var segments=key.split(".");var source=segments[0].replace(/\//g,".");return{source:locale+"."+source,sourceFallback:this.getFallback()+"."+source,entries:segments.slice(1)}};Lang.prototype._getMessage=function(key,locale){locale=locale||this.getLocale();key=this._parseKey(key,locale);if(this.messages[key.source]===undefined&&this.messages[key.sourceFallback]===undefined){return null}var message=this.messages[key.source];var entries=key.entries.slice();var subKey="";while(entries.length&&message!==undefined){var subKey=!subKey?entries.shift():subKey.concat(".",entries.shift());if(message[subKey]!==undefined){message=message[subKey];subKey=""}}if(typeof message!=="string"&&this.messages[key.sourceFallback]){message=this.messages[key.sourceFallback];entries=key.entries.slice();subKey="";while(entries.length&&message!==undefined){var subKey=!subKey?entries.shift():subKey.concat(".",entries.shift());if(message[subKey]){message=message[subKey];subKey=""}}}if(typeof message!=="string"){return null}return message};Lang.prototype._findMessageInTree=function(pathSegments,tree){while(pathSegments.length&&tree!==undefined){var dottedKey=pathSegments.join(".");if(tree[dottedKey]){tree=tree[dottedKey];break}tree=tree[pathSegments.shift()]}return tree};Lang.prototype._applyReplacements=function(message,replacements){for(var replace in replacements){message=message.replace(new RegExp(":"+replace,"gi"),function(match){var value=replacements[replace];var allCaps=match===match.toUpperCase();if(allCaps){return value.toUpperCase()}var firstCap=match===match.replace(/\w/i,function(letter){return letter.toUpperCase()});if(firstCap){return value.charAt(0).toUpperCase()+value.slice(1)}return value})}return message};Lang.prototype._testInterval=function(count,interval){if(typeof interval!=="string"){throw"Invalid interval: should be a string."}interval=interval.trim();var matches=interval.match(intervalRegexp);if(!matches){throw"Invalid interval: "+interval}if(matches[2]){var items=matches[2].split(",");for(var i=0;i<items.length;i++){if(parseInt(items[i],10)===count){return true}}}else{matches=matches.filter(function(match){return!!match});var leftDelimiter=matches[1];var leftNumber=convertNumber(matches[2]);if(leftNumber===Infinity){leftNumber=-Infinity}var rightNumber=convertNumber(matches[3]);var rightDelimiter=matches[4];return(leftDelimiter==="["?count>=leftNumber:count>leftNumber)&&(rightDelimiter==="]"?count<=rightNumber:count<rightNumber)}return false};Lang.prototype._getPluralForm=function(count){switch(this.locale){case"az":case"bo":case"dz":case"id":case"ja":case"jv":case"ka":case"km":case"kn":case"ko":case"ms":case"th":case"tr":case"vi":case"zh":return 0;case"af":case"bn":case"bg":case"ca":case"da":case"de":case"el":case"en":case"eo":case"es":case"et":case"eu":case"fa":case"fi":case"fo":case"fur":case"fy":case"gl":case"gu":case"ha":case"he":case"hu":case"is":case"it":case"ku":case"lb":case"ml":case"mn":case"mr":case"nah":case"nb":case"ne":case"nl":case"nn":case"no":case"om":case"or":case"pa":case"pap":case"ps":case"pt":case"so":case"sq":case"sv":case"sw":case"ta":case"te":case"tk":case"ur":case"zu":return count==1?0:1;case"am":case"bh":case"fil":case"fr":case"gun":case"hi":case"hy":case"ln":case"mg":case"nso":case"xbr":case"ti":case"wa":return count===0||count===1?0:1;case"be":case"bs":case"hr":case"ru":case"sr":case"uk":return count%10==1&&count%100!=11?0:count%10>=2&&count%10<=4&&(count%100<10||count%100>=20)?1:2;case"cs":case"sk":return count==1?0:count>=2&&count<=4?1:2;case"ga":return count==1?0:count==2?1:2;case"lt":return count%10==1&&count%100!=11?0:count%10>=2&&(count%100<10||count%100>=20)?1:2;case"sl":return count%100==1?0:count%100==2?1:count%100==3||count%100==4?2:3;case"mk":return count%10==1?0:1;case"mt":return count==1?0:count===0||count%100>1&&count%100<11?1:count%100>10&&count%100<20?2:3;case"lv":return count===0?0:count%10==1&&count%100!=11?1:2;case"pl":return count==1?0:count%10>=2&&count%10<=4&&(count%100<12||count%100>14)?1:2;case"cy":return count==1?0:count==2?1:count==8||count==11?2:3;case"ro":return count==1?0:count===0||count%100>0&&count%100<20?1:2;case"ar":return count===0?0:count==1?1:count==2?2:count%100>=3&&count%100<=10?3:count%100>=11&&count%100<=99?4:5;default:return 0}};return Lang});

(function () {
    Lang = new Lang();
    Lang.setMessages({"GJ.js":{"album":"Album","album_category":"Album Category","allowed_types":"Allowed file types: png, jpg, jpeg.","apply":"Apply","apr":"Apr","aug":"Aug","cancel":"Cancel","cancel_delete":"Cancel","category":"Category","comment":"Comment","contact":"Contact","custom":"Custom","dec":"Dec","delete":"Delete","delete_message":"has been deleted","delete_msg":"has been deleted","delete_warning":"Are you sure you want to delete this ","delete_warning_post":"Are you sure you want to delete this post ?","deleted":"Deleted !!!","enter_ai_content":"Enter AI Content","enter_article_content":"Enter Article Content","enter_audio_content":"Enter Audio Content","enter_gallery_content":"Enter Gallery Content","enter_page_content":"Enter Page Content","enter_sort_list_content":"Enter Sort List Content","enter_terms_conditions":"Enter Terms & Conditions","enter_video_content":"Enter Video Content","error":"Error","feb":"Feb","fri":"FRI","from":"From","gallery":"Gallery","image_error":"The image must be a file of type: png, jpg, jpeg, webp, svg.","image_error_excel":"The image must be a file of type: png, jpg, jpeg, pdf,excel","image_warning":"is not valid! Allowed file types: png, jpg, jpeg.","invalid_facebook_url":"Please enter a valid Facebook URL","invalid_instagram_url":"Please enter a valid Instagram URL","invalid_linkedin_url":"Please enter a valid LinkedIn URL","invalid_pinterest_url":"Please enter a valid Pinterest URL","invalid_telegram_url":"Please enter a valid Telegram URL","invalid_twitter_url":"Please enter a valid Twitter URL","invalid_vk_url":"Please enter a valid VK URL","invalid_youtube_url":"Please enter a valid Youtube URL","jan":"Jan","jul":"Jul","jun":"Jun","language":"Language","last_week":"Last Week","mail_content_required":"Mail Content is required","mail_subject_required":"Mail Subject is required","manual_payment_guide":"Manual Payment Guide","mar":"Mar","max":"The :attribute must not be greater than :max.","may":"May","menu":"Menu","mon":"MON","news_letters":"News Letters","no_results":"No results found","no_results_found":"No results found","nov":"Nov","oct":"Oct","ok":"Ok","page":"Page","plan":"Plan","poll":"Poll","post":"Post","processing":"Processing...","purchase":"Purchase","required":"The :attribute field is required.","required_privacy":"Privacy field is required","required_support":"Support field is required","required_t&c":"Terms & conditions field is required","required_username":"Username field is required","role":"Role","rss-feed":"RSS Feed","sat":"SAT","search":"Search","select_album":"Select Album","select_category":"Select Category","select_language":"Select Language","select_subcategory":"Select Sub Category","sep":"Sep","staff":"Staff","sub_category":"Sub Category","success_msg":"Message has been sent successfully.","sun":"SUN","this_week":"This Week","thu":"THU","thumbnail_image":"Please enter a valid URL","to":"To","total_vote":"Total Vote","tue":"TUE","video_error":"The image must be a file of type: mp4, mov, mkv, webm, avi.","view_option":"View Option","views":"Views","wed":"WED"},"ar.js":{"album":"\u0627\u0644\u0623\u0644\u0628\u0648\u0645","album_category":"\u0641\u0626\u0629 \u0627\u0644\u0623\u0644\u0628\u0648\u0645","allowed_types":"\u0623\u0646\u0648\u0627\u0639 \u0627\u0644\u0645\u0644\u0641\u0627\u062a \u0627\u0644\u0645\u0633\u0645\u0648\u062d \u0628\u0647\u0627: png\u060c jpg\u060c jpeg.","apply":"\u064a\u062a\u0642\u062f\u0645","apr":"\u0623\u0628\u0631\u064a\u0644","aug":"\u0623\u063a\u0633\u0637\u0633","cancel":"\u064a\u0644\u063a\u064a","cancel_delete":"\u064a\u0644\u063a\u064a","category":"\u0641\u0626\u0629","comment":"\u062a\u0639\u0644\u064a\u0642","contact":"\u0627\u062a\u0635\u0627\u0644","custom":"\u0645\u062e\u0635\u0635","dec":"\u062f\u064a\u0633\u0645\u0628\u0631","delete":"\u064a\u0645\u0633\u062d","delete_message":"\u0642\u062f \u062a\u0645 \u062d\u0630\u0641","delete_msg":"\u0642\u062f \u062a\u0645 \u062d\u0630\u0641","delete_warning":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u062d\u0630\u0641 \u0647\u0630\u0627","delete_warning_post":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u062d\u0630\u0641 \u0647\u0630\u0647 \u0627\u0644\u0645\u0634\u0627\u0631\u0643\u0629 \u061f","deleted":"\u062a\u0645 \u0627\u0644\u062d\u0630\u0641 !!!","enter_ai_content":"\u0627\u0654\u062f\u062e\u0644 \u0645\u062d\u062a\u0648\u0649 AI","enter_article_content":"\u0627\u0654\u062f\u062e\u0644 \u0645\u062d\u062a\u0648\u0649 \u0627\u0644\u0645\u0642\u0627\u0644\u0629","enter_audio_content":"\u0627\u0654\u062f\u062e\u0644 \u0645\u062d\u062a\u0648\u0649 \u0627\u0644\u0635\u0648\u062a","enter_gallery_content":"\u0627\u0654\u062f\u062e\u0644 \u0645\u062d\u062a\u0648\u0649 \u0627\u0644\u0635\u0627\u0644\u0629","enter_page_content":"\u0627\u0654\u062f\u062e\u0644 \u0645\u062d\u062a\u0648\u0649 \u0627\u0644\u0635\u0641\u062d\u0629","enter_sort_list_content":"\u0627\u0654\u062f\u062e\u0644 \u0645\u062d\u062a\u0648\u0649 \u0642\u0627\u064a\u0654\u0645\u0629 \u0627\u0644\u0641\u0631\u0632","enter_video_content":"\u0627\u0654\u062f\u062e\u0644 \u0645\u062d\u062a\u0648\u0649 \u0627\u0644\u0641\u064a\u062f\u064a\u0648","error":"\u062e\u0637\u0627\u0654","feb":"\u0641\u0628\u0631\u0627\u064a\u0631","fri":"\u0627\u0644\u062c\u0645\u0639\u0629","from":"\u0645\u0646","gallery":"\u0635\u0627\u0644\u0629 \u0639\u0631\u0636","image_error":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0635\u0648\u0631\u0629 \u0645\u0644\u0641\u064b\u0627 \u0645\u0646 \u0627\u0644\u0646\u0648\u0639: png\u060c jpg\u060c jpeg\u060c webp\u060c svg.","image_error_excel":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0635\u0648\u0631\u0629 \u0645\u0644\u0641\u064b\u0627 \u0645\u0646 \u0627\u0644\u0646\u0648\u0639: png\u060c jpg\u060c jpeg\u060c pdf\u060c excel","image_warning":"\u063a\u064a\u0631 \u0635\u0627\u0644\u062d! \u0623\u0646\u0648\u0627\u0639 \u0627\u0644\u0645\u0644\u0641\u0627\u062a \u0627\u0644\u0645\u0633\u0645\u0648\u062d \u0628\u0647\u0627: png\u060c jpg\u060c jpeg.","invalid_facebook_url":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d \u0644\u0641\u064a\u0633\u0628\u0648\u0643","invalid_instagram_url":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d \u0644\u0640 Instagram","invalid_linkedin_url":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d \u0644\u0640 LinkedIn","invalid_pinterest_url":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d \u0644\u0640 Pinterest","invalid_telegram_url":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d \u0644\u0640 Telegram","invalid_twitter_url":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d \u0644\u062a\u0648\u064a\u062a\u0631","invalid_vk_url":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d \u0644\u0640 VK","invalid_youtube_url":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d \u0639\u0644\u0649 YouTube","jan":"\u064a\u0646\u0627\u064a\u0631","jul":"\u064a\u0648\u0644\u064a\u0648","jun":"\u064a\u0648\u0646\u064a\u0648","language":"\u0644\u063a\u0629","last_week":"\u0627\u0644\u0623\u0633\u0628\u0648\u0639 \u0627\u0644\u0645\u0627\u0636\u064a","mail_content_required":"\u0645\u062d\u062a\u0648\u0649 \u0627\u0644\u0628\u0631\u064a\u062f \u0645\u0637\u0644\u0648\u0628","mail_subject_required":"\u0645\u0648\u0636\u0648\u0639 \u0627\u0644\u0628\u0631\u064a\u062f \u0645\u0637\u0644\u0648\u0628","manual_payment_guide":"\u062f\u0644\u064a\u0644 \u0627\u0644\u062f\u0641\u0639 \u0627\u0644\u064a\u062f\u0648\u064a","mar":"\u0645\u0627\u0631\u0633","max":"\u064a\u062c\u0628 \u0623\u0644\u0627 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629 \u0623\u0643\u0628\u0631 \u0645\u0646 :max.","may":"\u0645\u0627\u064a\u0648","menu":"\u0642\u0627\u0626\u0645\u0629 \u0637\u0639\u0627\u0645","mon":"\u0645\u0648\u0646","news_letters":"\u0627\u0644\u0646\u0634\u0631\u0629 \u0627\u0644\u0625\u062e\u0628\u0627\u0631\u064a\u0629","no_results":"\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0646\u062a\u0627\u0626\u062c","no_results_found":"\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0646\u062a\u0627\u0626\u062c","nov":"\u0646\u0648\u0641\u0645\u0628\u0631","oct":"\u0623\u0643\u062a\u0648\u0628\u0631","ok":"\u0646\u0639\u0645","page":"\u0635\u0641\u062d\u0629","paypal_client_id":"\u062d\u0642\u0644 \u0645\u0639\u0631\u0641 \u0627\u0644\u0639\u0645\u064a\u0644 \u0644\u0640 \u0628\u0627\u064a \u0628\u0627\u0644 \u0645\u0637\u0644\u0648\u0628","paypal_mode":"\u062d\u0642\u0644 \u0648\u0636\u0639 \u0628\u0627\u064a \u0628\u0627\u0644 \u0645\u0637\u0644\u0648\u0628","paypal_secret":"\u062d\u0642\u0644 \u0627\u0644\u0645\u0641\u062a\u0627\u062d \u0627\u0644\u0633\u0631\u064a \u0644\u0640 \u0628\u0627\u064a \u0628\u0627\u0644 \u0645\u0637\u0644\u0648\u0628","plan":"\u064a\u062e\u0637\u0637","poll":"\u062a\u0635\u0648\u064a\u062a","post":"\u0628\u0631\u064a\u062f","processing":"\u062c\u0627\u0631\u064a \u0627\u0644\u0645\u0639\u0627\u0644\u062c\u0629","purchase":"\u0634\u0631\u0627\u0621","required":"\u062d\u0642\u0644 \u0627\u0644\u0633\u0645\u0629 \u0645\u0637\u0644\u0648\u0628.","required_privacy":"\u062d\u0642\u0644 \u0627\u0644\u062e\u0635\u0648\u0635\u064a\u0629 \u0645\u0637\u0644\u0648\u0628","required_support":"\u062d\u0642\u0644 \u0627\u0644\u062f\u0639\u0645 \u0645\u0637\u0644\u0648\u0628","required_t&c":"\u062d\u0642\u0644 \u0627\u0644\u0634\u0631\u0648\u0637 \u0648\u0627\u0644\u0623\u062d\u0643\u0627\u0645 \u0645\u0637\u0644\u0648\u0628","required_username":"\u062d\u0642\u0644 \u0627\u0633\u0645 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645 \u0645\u0637\u0644\u0648\u0628","role":"\u062f\u0648\u0631","rss-feed":"\u062a\u063a\u0630\u064a\u0629 \u0627\u0631 \u0627\u0633 \u0627\u0633","sat":"\u0642\u0639\u062f","search":"\u064a\u0628\u062d\u062b","select_album":"\u062d\u062f\u062f \u0627\u0644\u0623\u0644\u0628\u0648\u0645","select_category":"\u0627\u062e\u062a\u0631 \u0627\u0644\u0641\u0626\u0629","select_language":"\u0627\u062e\u062a\u0627\u0631 \u0627\u0644\u0644\u063a\u0629","select_subcategory":"\u062d\u062f\u062f \u0627\u0644\u0641\u0626\u0629 \u0627\u0644\u0641\u0631\u0639\u064a\u0629","sep":"\u0633\u0628\u062a\u0645\u0628\u0631","staff":"\u0637\u0627\u0642\u0645 \u0639\u0645\u0644","stripe_key":"\u062d\u0642\u0644 \u0645\u0641\u062a\u0627\u062d \u0634\u0631\u064a\u0637 \u0645\u0637\u0644\u0648\u0628","stripe_secret":"\u062d\u0642\u0644 \u0627\u0644\u0645\u0641\u062a\u0627\u062d \u0627\u0644\u0633\u0631\u064a \u0644\u0640 \u0634\u0631\u064a\u0637 \u0645\u0637\u0644\u0648\u0628","sub_category":"\u062a\u0635\u0646\u064a\u0641 \u0641\u0631\u0639\u064a","success_msg":"\u062a\u0645 \u0625\u0631\u0633\u0627\u0644 \u0627\u0644\u0631\u0633\u0627\u0644\u0629 \u0628\u0646\u062c\u0627\u062d.","sun":"\u0634\u0645\u0633","this_week":"\u0647\u0630\u0627 \u0627\u0644\u0627\u0633\u0628\u0648\u0639","thu":"\u0627\u0644\u062e\u0645\u064a\u0633","thumbnail_image":"\u0623\u062f\u062e\u0644 \u0631\u0627\u0628\u0637 \u0635\u062d\u064a\u062d \u0645\u0646 \u0641\u0636\u0644\u0643","to":"\u0644","total_vote":"\u0625\u062c\u0645\u0627\u0644\u064a \u0627\u0644\u062a\u0635\u0648\u064a\u062a","tue":"\u0627\u0644\u062b\u0644\u0627\u062b\u0627\u0621","video_error":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0635\u0648\u0631\u0629 \u0645\u0644\u0641\u064b\u0627 \u0645\u0646 \u0627\u0644\u0646\u0648\u0639: mp4\u060c mov\u060c mkv\u060c webm\u060c avi.","view_option":"\u0639\u0631\u0636 \u0627\u0644\u062e\u064a\u0627\u0631","views":"\u0627\u0644\u0622\u0631\u0627\u0621","wed":"\u062a\u0632\u0648\u062c"},"de.js":{"album":"Album","album_category":"Albumkategorie","allowed_types":"Zul\u00e4ssige Dateitypen: PNG, JPG, JPEG.","apply":"Anwenden","apr":"Apr","aug":"Aug","cancel":"Stornieren","cancel_delete":"Stornieren","category":"Kategorie","comment":"Kommentar","contact":"Kontakt","custom":"Brauch","dec":"Dez","delete":"L\u00f6schen","delete_message":"wurde gel\u00f6scht","delete_msg":"wurde gel\u00f6scht","delete_warning":"Sind Sie sicher, dass Sie dies l\u00f6schen m\u00f6chten?","delete_warning_post":"Sind Sie sicher, dass Sie diesen Beitrag l\u00f6schen m\u00f6chten?","deleted":"Gel\u00f6scht!!!","enter_ai_content":"KI-Inhalt eingeben","enter_article_content":"Artikelinhalt eingeben","enter_audio_content":"Audioinhalt eingeben","enter_gallery_content":"Galerieinhalt eingeben","enter_page_content":"Seiteninhalt eingeben","enter_sort_list_content":"Sortierlisteninhalt eingeben","enter_terms_conditions":"Gesch\u00e4ftsbedingungen eingeben","enter_video_content":"Videoinhalt eingeben","error":"Fehler","feb":"Febr","fri":"FR","from":"Aus","gallery":"Galerie","image_error":"Das Bild muss eine Datei des folgenden Typs sein: PNG, JPG, JPEG, WebP, SVG.","image_error_excel":"Das Bild muss eine Datei des folgenden Typs sein: PNG, JPG, JPEG, PDF, Excel","image_warning":"ist ung\u00fcltig! Zul\u00e4ssige Dateitypen: PNG, JPG, JPEG.","invalid_facebook_url":"Bitte geben Sie eine g\u00fcltige Facebook-URL ein","invalid_instagram_url":"Bitte geben Sie eine g\u00fcltige Instagram-URL ein","invalid_linkedin_url":"Bitte geben Sie eine g\u00fcltige LinkedIn-URL ein","invalid_pinterest_url":"Bitte geben Sie eine g\u00fcltige Pinterest-URL ein","invalid_telegram_url":"Bitte geben Sie eine g\u00fcltige Telegram-URL ein","invalid_twitter_url":"Bitte geben Sie eine g\u00fcltige Twitter-URL ein","invalid_vk_url":"Bitte geben Sie eine g\u00fcltige VK-URL ein","invalid_youtube_url":"Bitte geben Sie eine g\u00fcltige Youtube-URL ein","jan":"Jan","jul":"Juli","jun":"Jun","language":"Sprache","last_week":"Letzte Woche","mail_content_required":"E-Mail-Inhalt ist erforderlich","mail_subject_required":"E-Mail-Betreff ist erforderlich","manual_payment_guide":"Anleitung zur manuellen Zahlung","mar":"Besch\u00e4digen","max":"Das :attribute darf nicht gr\u00f6\u00dfer als :max sein.","may":"Mai","menu":"Speisekarte","mon":"MO","news_letters":"Newsletter","no_results":"keine Ergebnisse gefunden","no_results_found":"keine Ergebnisse gefunden","nov":"Nov","oct":"Okt","ok":"OK","page":"Seite","paypal_client_id":"PayPal Client ID ist erforderlich","paypal_mode":"PayPal Modus ist erforderlich","paypal_secret":"PayPal Geheimschl\u00fcssel ist erforderlich","plan":"Planen","poll":"Umfrage","post":"Post","processing":"Verarbeitung...","purchase":"Kaufen","required":"Das Feld :attribute ist erforderlich.","required_privacy":"Das Feld \u201eDatenschutz\u201c ist erforderlich","required_support":"Das Support-Feld ist erforderlich","required_t&c":"Das Feld \u201eAllgemeine Gesch\u00e4ftsbedingungen\u201c ist erforderlich","required_username":"Das Feld \u201eBenutzername\u201c ist erforderlich","role":"Rolle","rss-feed":"RSS-Feed","sat":"SA","search":"Suchen","select_album":"W\u00e4hlen Sie Album","select_category":"Kategorie w\u00e4hlen","select_language":"Sprache ausw\u00e4hlen","select_subcategory":"W\u00e4hlen Sie Unterkategorie","sep":"Sept","staff":"Mitarbeiter","stripe_key":"Stripe Schl\u00fcssel ist erforderlich","stripe_secret":"Stripe Geheimschl\u00fcssel ist erforderlich","sub_category":" Unterkategorie","success_msg":"Die Nachricht wurde erfolgreich gesendet.","sun":"SONNE","this_week":"Diese Woche","thu":"DO","thumbnail_image":"Bitte geben Sie eine g\u00fcltige URL ein","to":"Zu","total_vote":"Gesamtstimme","tue":"DI","video_error":"Das Bild muss eine Datei des folgenden Typs sein: mp4, mov, mkv, webm, avi.","view_option":"Ansichtsoption","views":"Ansichten","wed":"HEIRATEN"},"en.js":{"album":"Album","album_category":"Album Category","allowed_types":"Allowed file types: png, jpg, jpeg.","apply":"Apply","apr":"Apr","aug":"Aug","cancel":"Cancel","cancel_delete":"Cancel","category":"Category","comment":"Comment","contact":"Contact","custom":"Custom","dec":"Dec","delete":"Delete","delete_message":"has been deleted","delete_msg":"has been deleted","delete_warning":"Are you sure you want to delete this ","delete_warning_post":"Are you sure you want to delete this post ?","deleted":"Deleted !!!","enter_ai_content":"Enter AI Content","enter_article_content":"Enter Article Content","enter_audio_content":"Enter Audio Content","enter_gallery_content":"Enter Gallery Content","enter_page_content":"Enter Page Content","enter_sort_list_content":"Enter Sort List Content","enter_terms_conditions":"Enter Terms & Conditions","enter_video_content":"Enter Video Content","error":"Error","feb":"Feb","fri":"FRI","from":"From","gallery":"Gallery","image_error":"The image must be a file of type: png, jpg, jpeg, webp, svg.","image_error_excel":"The image must be a file of type: png, jpg, jpeg, pdf,excel","image_warning":"is not valid! Allowed file types: png, jpg, jpeg.","invalid_facebook_url":"Please enter a valid Facebook URL","invalid_instagram_url":"Please enter a valid Instagram URL","invalid_linkedin_url":"Please enter a valid LinkedIn URL","invalid_pinterest_url":"Please enter a valid Pinterest URL","invalid_telegram_url":"Please enter a valid Telegram URL","invalid_twitter_url":"Please enter a valid Twitter URL","invalid_vk_url":"Please enter a valid VK URL","invalid_youtube_url":"Please enter a valid Youtube URL","jan":"Jan","jul":"Jul","jun":"Jun","language":"Language","last_week":"Last Week","mail_content_required":"Mail Content is required","mail_subject_required":"Mail Subject is required","manual_payment_guide":"Manual Payment Guide","mar":"Mar","max":"The :attribute must not be greater than :max.","may":"May","menu":"Menu","mon":"MON","news_letters":"News Letters","no_results":"No results found","no_results_found":"No results found","nov":"Nov","oct":"Oct","ok":"Ok","page":"Page","paypal_client_id":"Paypal client key field is required","paypal_mode":"Paypal mode field is required","paypal_secret":"Paypal secret key field is required","plan":"Plan","poll":"Poll","post":"Post","processing":"Processing...","purchase":"Purchase","required":"The :attribute field is required.","required_privacy":"Privacy field is required","required_support":"Support field is required","required_t&c":"Terms & conditions field is required","required_username":"Username field is required","role":"Role","rss-feed":"RSS Feed","sat":"SAT","search":"Search","select_album":"Select Album","select_category":"Select Category","select_language":"Select Language","select_subcategory":"Select Sub Category","sep":"Sep","staff":"Staff","stripe_key":"Stripe key field is required","stripe_secret":"Stripe secret key field is required","sub_category":"Sub Category","success_msg":"Message has been sent successfully.","sun":"SUN","this_week":"This Week","thu":"THU","thumbnail_image":"Please enter a valid URL","to":"To","total_vote":"Total Vote","tue":"TUE","video_error":"The image must be a file of type: mp4, mov, mkv, webm, avi.","view_option":"View Option","views":"Views","wed":"WED"},"er.js":{"album":"Album","album_category":"Album Category","allowed_types":"Allowed file types: png, jpg, jpeg.","apply":"Apply","apr":"Apr","aug":"Aug","cancel":"Cancel","cancel_delete":"Cancel","category":"Category","comment":"Comment","contact":"Contact","custom":"Custom","dec":"Dec","delete":"Delete","delete_message":"has been deleted","delete_msg":"has been deleted","delete_warning":"Are you sure you want to delete this ","delete_warning_post":"Are you sure you want to delete this post ?","deleted":"Deleted !!!","enter_ai_content":"Enter AI Content","enter_article_content":"Enter Article Content","enter_audio_content":"Enter Audio Content","enter_gallery_content":"Enter Gallery Content","enter_page_content":"Enter Page Content","enter_sort_list_content":"Enter Sort List Content","enter_terms_conditions":"Enter Terms & Conditions","enter_video_content":"Enter Video Content","error":"Error","feb":"Feb","fri":"FRI","from":"From","gallery":"Gallery","image_error":"The image must be a file of type: png, jpg, jpeg, webp, svg.","image_error_excel":"The image must be a file of type: png, jpg, jpeg, pdf,excel","image_warning":"is not valid! Allowed file types: png, jpg, jpeg.","invalid_facebook_url":"Please enter a valid Facebook URL","invalid_instagram_url":"Please enter a valid Instagram URL","invalid_linkedin_url":"Please enter a valid LinkedIn URL","invalid_pinterest_url":"Please enter a valid Pinterest URL","invalid_telegram_url":"Please enter a valid Telegram URL","invalid_twitter_url":"Please enter a valid Twitter URL","invalid_vk_url":"Please enter a valid VK URL","invalid_youtube_url":"Please enter a valid Youtube URL","jan":"Jan","jul":"Jul","jun":"Jun","language":"Language","last_week":"Last Week","mail_content_required":"Mail Content is required","mail_subject_required":"Mail Subject is required","manual_payment_guide":"Manual Payment Guide","mar":"Mar","max":"The :attribute must not be greater than :max.","may":"May","menu":"Menu","mon":"MON","news_letters":"News Letters","no_results":"No results found","no_results_found":"No results found","nov":"Nov","oct":"Oct","ok":"Ok","page":"Page","plan":"Plan","poll":"Poll","post":"Post","processing":"Processing...","purchase":"Purchase","required":"The :attribute field is required.","required_privacy":"Privacy field is required","required_support":"Support field is required","required_t&c":"Terms & conditions field is required","required_username":"Username field is required","role":"Role","rss-feed":"RSS Feed","sat":"SAT","search":"Search","select_album":"Select Album","select_category":"Select Category","select_language":"Select Language","select_subcategory":"Select Sub Category","sep":"Sep","staff":"Staff","sub_category":"Sub Category","success_msg":"Message has been sent successfully.","sun":"SUN","this_week":"This Week","thu":"THU","thumbnail_image":"Please enter a valid URL","to":"To","total_vote":"Total Vote","tue":"TUE","video_error":"The image must be a file of type: mp4, mov, mkv, webm, avi.","view_option":"View Option","views":"Views","wed":"WED"},"es.js":{"album":"\u00c1lbum","album_category":"Categor\u00eda de \u00e1lbum","allowed_types":"Tipos de archivos permitidos: png, jpg, jpeg.","apply":"Aplicar","apr":"Abr","aug":"Ago","cancel":"Cancelar","cancel_delete":"Cancelar","category":"Categor\u00eda","comment":"Comentario","contact":"Contacto","custom":"Costumbre","dec":"Dic","delete":"Borrar","delete_message":"ha sido eliminado","delete_msg":"ha sido eliminado","delete_warning":"\u00bfEst\u00e1s segura de que quieres eliminar esto?","delete_warning_post":"\u00bfEst\u00e1s seguro de que deseas eliminar esta publicaci\u00f3n?","deleted":"Eliminado !!!","enter_ai_content":"Ingrese el contenido de IA","enter_article_content":"Ingrese el contenido del art\u00edculo","enter_audio_content":"Ingrese el contenido de audio","enter_gallery_content":"Ingrese el contenido de la galer\u00eda","enter_page_content":"Ingrese el contenido de la p\u00e1gina","enter_sort_list_content":"Ingrese el contenido de la lista de clasificaci\u00f3n","enter_terms_conditions":"Ingrese los t\u00e9rminos y condiciones","enter_video_content":"Ingrese el contenido del video","error":"Error","feb":"Feb","fri":"VIE","from":"De","gallery":"Galer\u00eda","image_error":"La imagen debe ser un archivo de tipo: png, jpg, jpeg, webp, svg.","image_error_excel":"La imagen debe ser un archivo de tipo: png, jpg, jpeg, pdf, excel","image_warning":"\u00a1no es v\u00e1lido! Tipos de archivos permitidos: png, jpg, jpeg.","invalid_facebook_url":"Por favor ingresa una URL v\u00e1lida de Facebook","invalid_instagram_url":"Por favor ingresa una URL de Instagram v\u00e1lida","invalid_linkedin_url":"Introduce una URL de LinkedIn v\u00e1lida","invalid_pinterest_url":"Por favor ingresa una URL v\u00e1lida de Pinterest","invalid_telegram_url":"Por favor ingresa una URL v\u00e1lida de Telegram","invalid_twitter_url":"Por favor ingresa una URL de Twitter v\u00e1lida","invalid_vk_url":"Por favor ingresa una URL VK v\u00e1lida","invalid_youtube_url":"Por favor ingresa una URL v\u00e1lida de Youtube","jan":"Ene","jul":"Jul","jun":"Jun","language":"Idioma","last_week":"La semana pasada","mail_content_required":"Se requiere contenido de correo","mail_subject_required":"El asunto del correo es obligatorio","manual_payment_guide":"Gu\u00eda de pago manual","mar":"Mar","max":"El :atributo no debe ser mayor que :max.","may":"Puede","menu":"Men\u00fa","mon":"LUN","news_letters":"Boletin informativo","no_results":"No se han encontrado resultados","no_results_found":"No se han encontrado resultados","nov":"Nov","oct":"Oct","ok":"De acuerdo","page":"P\u00e1gina","paypal_client_id":"Se requiere el ID de cliente de PayPal","paypal_mode":"Se requiere el modo de PayPal","paypal_secret":"Se requiere la clave secreta de PayPal","plan":"Plan","poll":"Encuesta","post":"Correo","processing":"Procesando...","purchase":"Compra","required":"El campo :atributo es obligatorio.","required_privacy":"El campo de privacidad es obligatorio","required_support":"El campo de soporte es obligatorio","required_t&c":"El campo T\u00e9rminos y condiciones es obligatorio","required_username":"El campo de nombre de usuario es obligatorio","role":"Role","rss-feed":"RSS Feed","sat":"SE SENT\u00d3","search":"Buscar","select_album":"Seleccionar \u00e1lbum","select_category":"selecciona una categor\u00eda","select_language":"Seleccione el idioma","select_subcategory":"Seleccionar subcategor\u00eda","sep":"Sep","staff":"Personal","stripe_key":"Se requiere la clave de Stripe","stripe_secret":"Se requiere la clave secreta de Stripe","sub_category":"Subcategor\u00eda","success_msg":"El mensaje ha sido enviado exitosamente.","sun":"SOL","this_week":"Esta semana","thu":"JUE","thumbnail_image":"Por favor introduzca un URL v\u00e1lido","to":"A","total_vote":"Voto total","tue":"MAR","video_error":"La imagen debe ser un archivo de tipo: mp4, mov, mkv, webm, avi.","view_option":"Ver opci\u00f3n","views":"Puntos de vista","wed":"CASARSE"},"zh.js":{"album":"\u5c08\u8f2f","album_category":"\u5c08\u8f2f\u985e\u5225","allowed_types":"\u5141\u8a31\u7684\u6a94\u6848\u985e\u578b\uff1apng\u3001jpg\u3001jpeg\u3002","apply":"\u7533\u8acb","apr":"\u56db\u6708","aug":"\u516b\u6708","cancel":"\u53d6\u6d88","cancel_delete":"\u53d6\u6d88","category":"\u985e\u5225","comment":"\u8a55\u8ad6","contact":"\u63a5\u89f8","custom":"\u98a8\u4fd7","dec":"\u5341\u4e8c\u6708","delete":"\u522a\u9664","delete_message":"\u5df2\u522a\u9664","delete_msg":"\u5df2\u522a\u9664","delete_warning":"\u4f60\u78ba\u5b9a\u8981\u522a\u9664\u9019\u500b\u55ce","delete_warning_post":"\u4f60\u78ba\u5b9a\u4f60\u8981\u522a\u9664\u9019\u500b\u8cbc\u6587 \uff1f","deleted":"\u5df2\u522a\u9664\uff01\uff01\uff01","enter_ai_content":"\u8f93\u5165\u4eba\u5de5\u667a\u80fd\u5185\u5bb9","enter_article_content":"\u8f93\u5165\u6587\u7ae0\u5185\u5bb9","enter_audio_content":"\u8f93\u5165\u97f3\u9891\u5185\u5bb9","enter_gallery_content":"\u8f93\u5165\u753b\u5eca\u5185\u5bb9","enter_page_content":"\u8f93\u5165\u9875\u9762\u5185\u5bb9","enter_sort_list_content":"\u8f93\u5165\u6392\u5e8f\u5217\u8868\u5185\u5bb9","enter_terms_conditions":"\u8f93\u5165\u6761\u6b3e\u548c\u6761\u4ef6","enter_video_content":"\u8f93\u5165\u89c6\u9891\u5185\u5bb9","error":"\u932f\u8aa4","feb":"\u4e8c\u6708","fri":"\u5f17\u745e","from":"\u5f9e","gallery":"\u756b\u5eca","image_error":"\u5716\u50cf\u5fc5\u9808\u662f\u4ee5\u4e0b\u985e\u578b\u7684\u6a94\u6848\uff1apng\u3001jpg\u3001jpeg\u3001webp\u3001svg\u3002","image_error_excel":"\u5716\u50cf\u5fc5\u9808\u662f\u4ee5\u4e0b\u985e\u578b\u7684\u6a94\u6848\uff1apng\u3001jpg\u3001jpeg\u3001pdf\u3001excel","image_warning":"\u7121\u6548\uff01\u5141\u8a31\u7684\u6a94\u6848\u985e\u578b\uff1apng\u3001jpg\u3001jpeg\u3002","invalid_facebook_url":"\u8acb\u8f38\u5165\u6709\u6548\u7684 Facebook \u7db2\u5740","invalid_instagram_url":"\u8acb\u8f38\u5165\u6709\u6548\u7684 Instagram \u7db2\u5740","invalid_linkedin_url":"\u8acb\u8f38\u5165\u6709\u6548\u7684 LinkedIn \u7db2\u5740","invalid_pinterest_url":"\u8acb\u8f38\u5165\u6709\u6548\u7684 Pinterest \u7db2\u5740","invalid_telegram_url":"\u8acb\u8f38\u5165\u6709\u6548\u7684 Telegram \u7db2\u5740","invalid_twitter_url":"\u8acb\u8f38\u5165\u6709\u6548\u7684 Twitter \u7db2\u5740","invalid_vk_url":"\u8acb\u8f38\u5165\u6709\u6548\u7684 VK \u7db2\u5740","invalid_youtube_url":"\u8acb\u8f38\u5165\u6709\u6548\u7684 YouTube \u7db2\u5740","jan":"\u63da","jul":"\u4e03\u6708","jun":"\u541b","language":"\u8a9e\u8a00","last_week":"\u4e0a\u500b\u661f\u671f","mail_content_required":"\u90f5\u4ef6\u5167\u5bb9\u70ba\u5fc5\u586b\u9805","mail_subject_required":"\u90f5\u4ef6\u4e3b\u65e8\u70ba\u5fc5\u586b\u9805","manual_payment_guide":"\u624b\u52d5\u4ed8\u6b3e\u6307\u5357","mar":"\u4e09\u6708","max":":attribute \u4e0d\u5f97\u5927\u65bc:max\u3002","may":"\u4e94\u6708","menu":"\u9078\u55ae","mon":"\u9031\u4e00","news_letters":"\u901a\u8a0a","no_results":"\u672a\u627e\u5230\u7d50\u679c","no_results_found":"\u672a\u627e\u5230\u7d50\u679c","nov":"\u5341\u4e00\u6708","oct":"\u5341\u6708","ok":"\u597d\u7684","page":"\u9801","paypal_client_id":"\u9700\u8981 \u8d1d\u5b9d \u5ba2\u6237\u7aef ID","paypal_mode":"\u9700\u8981 \u8d1d\u5b9d \u6a21\u5f0f","paypal_secret":"\u9700\u8981 \u8d1d\u5b9d \u79d8\u5bc6\u5bc6\u94a5","plan":"\u8a08\u5283","poll":"\u8f2a\u8a62","post":"\u90f5\u653f","processing":"\u6b63\u5728\u8655\u7406...","purchase":"\u8cfc\u8cb7","required":":attribute \u6b04\u4f4d\u662f\u5fc5\u9700\u7684\u3002","required_privacy":"\u96b1\u79c1\u6b0a\u6b04\u4f4d\u70ba\u5fc5\u586b\u9805","required_support":"\u652f\u63f4\u6b04\u4f4d\u70ba\u5fc5\u586b\u9805","required_t&c":"\u689d\u6b3e\u548c\u689d\u4ef6\u6b04\u4f4d\u70ba\u5fc5\u586b\u9805","required_username":"\u7528\u6236\u540d\u5b57\u6bb5\u70ba\u5fc5\u586b\u9805","role":"\u89d2\u8272","rss-feed":"RSS\u8a02\u95b1","sat":"","search":"\u641c\u5c0b","select_album":"\u9078\u64c7\u5c08\u8f2f","select_category":"\u9078\u64c7\u985e\u5225","select_language":"\u9078\u64c7\u8a9e\u8a00","select_subcategory":"\u9078\u64c7\u5b50\u985e\u5225","sep":"\u4e5d\u6708","staff":"\u8077\u54e1","stripe_key":"\u9700\u8981 \u6761\u7eb9 \u5bc6\u94a5","stripe_secret":"\u9700\u8981 \u6761\u7eb9 \u79d8\u5bc6\u5bc6\u94a5","sub_category":"\u5b50\u985e\u5225","success_msg":"\u8a0a\u606f\u5df2\u6210\u529f\u767c\u9001\u3002","sun":"\u592a\u967d","this_week":"\u672c\u661f\u671f","thu":"\u9031\u56db","thumbnail_image":"\u8acb\u8f38\u5165\u6709\u6548\u7db2\u5740","to":"\u5230","total_vote":"\u7e3d\u7968\u6578","tue":"\u6cbb\u7642\u8cbb\u7528","video_error":"\u5716\u50cf\u5fc5\u9808\u662f\u4ee5\u4e0b\u985e\u578b\u7684\u6a94\u6848\uff1amp4\u3001mov\u3001mkv\u3001webm\u3001avi\u3002","view_option":"\u67e5\u770b\u9078\u9805","views":"\u610f\u898b","wed":"\u661f\u671f\u4e09"}});
})();
